/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#include <iostream>
#include <vector>

#include "common.h"

#include "matrica.hh"
#include "gustaMatrica.hh"
#include "gustaKvadratnaMatrica.hh"
#include "gustaSimetricnaMatrica.hh"
#include "retkaMatrica.hh"
#include "funkcije.hh"

namespace jwork {

T determinanta(gustaMatrica & A) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;

  gustaMatrica B(A);
  return B.gaussDeterminanta();
}


T determinanta(retkaMatrica & A) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;

  retkaMatrica B(A);
  return B.gaussDeterminanta();
}


void diagDominant(matrica & A) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;

  for (unsigned i=0;i<A.visina();i++) {
    T sum(A.absSumaReda(i));
    A.set(i,i,1.2*sum+1);
  }
}

void ispisi_vektore_za_matlab(matrica & x, unsigned br) {


   for (unsigned i=0;i<x.sirina();i++) {
      cout << "[ ";
      for (unsigned j=0;j<x.visina();j++) {
        cout << redukuj_sirinu(x.get(i,j),br) << ' ';
        if (j!=x.visina()-1)
          cout << " ; ";
      }
      cout << " ] " << endl;
    }
}

void matmul(const matrica & A, const matrica & B, matrica & C) {
  if (A.sirina()!=B.visina())
    throw DIMENZIJE_NISU_SAGLASNE;
  
  C.postaviNovuMatricu(B.sirina(),A.visina());

  for (unsigned i=0;i<C.sirina();i++)
    for (unsigned j=0;j<C.visina();j++) {
      T sum(0.0);
      for (unsigned k=0;k<A.sirina();k++) {
        sum+=A.get(k,j)*B.get(i,k);
      }
      C.set(i,j,sum);
    }  
}

/* 
 * Za CG metodu potrebno je da matrica A bude pozitivno definitna,
 * Ax=b (u opstem slucaju)
 * Ax=b / A'  (A' = A transponovano)
 * A'Ax=A'b
 * sistem ima isto resenje kao polazni, s' tim sto je matrica sistema
 * pozitivno definitna
**/

/*
 * matmul_At_A mnozi matricu A' sa matricom A i rezultat smesta u B
**/

void matmul_At_A(const matrica & A, matrica & B) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;

  B.postaviNovuMatricu(A.sirina(),A.visina());

  unsigned n=B.sirina();

  for (unsigned j(0);j<n;j++) {
    for (unsigned i(0);i<n;i++) {
      T sum(0.0);
      for (unsigned k(0);k<n;k++)
        sum+=A.get(j,k)*A.get(i,k);
      B.set(i,j,sum);
    }
  }
}

/*
 * matmul_At_b mnozi matricu (vektor ili vise vektora) b matricom A' (levo)
 * i smesta rezultat u bb 
**/

void matmul_At_b(const matrica & A, const matrica & b, matrica & bb) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;
  if (A.sirina() != b.visina()) 
    throw DIMENZIJE_NISU_SAGLASNE;

  bb.postaviNovuMatricu(b.sirina(),b.visina());

  unsigned n=A.visina();
  unsigned m=b.sirina();

  for (unsigned j(0);j<n;j++) {
    for (unsigned i(0);i<m;i++) {
      T sum(0.0);
      for (unsigned k(0);k<n;k++)
        sum+=A.get(j,k)*b.get(i,k);
      bb.set(i,j,sum);
    }
  }

}


void proveriSistem(const matrica & A, const matrica & b, const matrica & x) {
  for (unsigned k=0;k<b.sirina();k++) {
    cout << "{ ";
    for (unsigned j=0;j<A.visina();j++) {
      T sum(0.0);     
      for (unsigned i=0;i<A.sirina();i++) {
        sum+=A.get(i,j)*x.get(k,i);
      }
      if (fabs(sum)<NULA)
        sum=0;
      cout << sum << " ; ";
    }
    cout << "}" << endl;
  }
}


} // jwork
