/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#if !defined funkcije_hh
#define funkcije_hh

#include <iostream>
#include <vector>

#include "common.h"

#include "matrica.hh"
#include "gustaMatrica.hh"
#include "gustaKvadratnaMatrica.hh"
#include "gustaSimetricnaMatrica.hh"
#include "retkaMatrica.hh"

using namespace std;

namespace jwork {

T determinanta(gustaMatrica & A);
T determinanta(retkaMatrica & A);
void diagDominant(matrica & A);
void ispisi_vektore_za_matlab(matrica & x, unsigned br=6);

void matmul(const matrica & A, const matrica & B, matrica & C);
void matmul_At_A(const matrica & A, matrica & B);
void matmul_At_b(const matrica & A, const matrica & b, matrica & bb);

void proveriSistem(const matrica & A, const matrica & b, const matrica & x);

template <class TM>
bool inverzna(TM & A, TM & A1) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;

  TM B(A);
  return B.gaussInverzna(A1);
}


} // jwork


#endif

