/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
 * dokument: gustaMatrica.cc
 * opis    : Definicija klase gustaSimetricnaMatrica
 *           sa matematicke strane simetricna matrica bi trebalo da bude 
 *           specijalizacija kvadratne, ali time ne bi bio postignut efekat
 *           ustede memorije jer je kvadratna matrica kontejner, tako da 
 *           simetricna matrica predstavlja samo simetrican kontejner
 *           koji je naravno kvadratna matrica. U ovoj klasi je glavni
 *           zadatak pristupu elemtima, sve ostalo je implementirano slicno
 *           kao u klasi kvadratnaMatrica
 *
 * napomena: ako se nad ovom matricom rade manipulacije nad redovima i kolonam
 *           nece se postici ocekivan efekat jer matrica uvek zadrzava svoju
 *           simetricnost, tako da se ova matrica koristi za cuvanje 
 *           simetricnih matrica i konstantne operacije nad njima kao i za
 *           operacije koje nece kvariti njenu simetricnost
 *           racunanje determinante ili inverzne matrice gausovim postupkom
 *           kod ovog kontejnera nece dati ispravan rezultat
**/

#include <iostream>
#include "gustaSimetricnaMatrica.hh"

using namespace std;

namespace jwork {

gustaSimetricnaMatrica::gustaSimetricnaMatrica(unsigned dim) :
  matrica(dim,dim) {
  sz=(dim*dim+dim)/2;
  data = new T[sz];
}

gustaSimetricnaMatrica::gustaSimetricnaMatrica(const gustaSimetricnaMatrica &A) : 
  matrica(A.sirina(),A.visina()) {
  sz=A.sz;
  data=new T[sz];
  for (int i=sz-1;i>=0;i--)
    data[i]=A.data[i];
}

gustaSimetricnaMatrica & gustaSimetricnaMatrica::operator=(const gustaSimetricnaMatrica &A) {
  if (this != &A) {
    if ( sirina()!=A.sirina() ) {
      delete [] data;
      sz=A.sz;
      data=new T[sz];
    }
    promeni_dimenzije(A.sirina(),A.visina());
    for (int i=sz-1;i>=0;i--)
      data[i]=A.data[i];      
  }
  return *this;
}

gustaSimetricnaMatrica::~gustaSimetricnaMatrica() {
  delete [] data;
}

/*
 *  Kljucne metode koje ovu klasu razdvajaju od kvadratne matrice
 *  su get i set. Pre direktnog pristupa memoriji mora se izracunati
 *  pozicija elementa simetricne matrice u linearnoj memoriji.
 *            | 1                 |
 *            | 2  3   simetricno |
 *  neka je A=| 4  5  6           |
 *            | 7  8  9  10       |
 *            | 11 12 13 14 15    |
 *            | 16 17 18 19 20 21 |
 *  i neka je potrebno izvaditi broj 8 element(x=1,y=3) tada je
 *  potrebno preskociti (y-1) red i na to dodati x. Broj elemenata
 *  do y-1 reda iznosi (1+2+3) tj y*(y+1)/2
 * 
 *  ukoliko se zada (3,1) tj x>y potrebno je zameniti x i y
 */

T gustaSimetricnaMatrica::get(unsigned x, unsigned y) const {
  if (x>=sirina() || y>=visina())
    throw LOS_INDEKS_MATRICE;
  if (x>y)
    zameni<unsigned>(x,y);
  unsigned idx=(y*(y+1))/2+x;
  return data[idx];
}

void gustaSimetricnaMatrica::set(unsigned x, unsigned y, T broj) {
  if (x>=sirina() || y>=visina())
    throw LOS_INDEKS_MATRICE;
  if (x>y)
    zameni<unsigned>(x,y);
  unsigned idx=(y*(y+1))/2+x;
  data[idx]=broj;
}

void gustaSimetricnaMatrica::randomN(T max, T min) {
  for (int i=sz-1;i>=0;i--) {
    T rnd=T(1+(int) (T(max*2)*rand()/(RAND_MAX+1.0)));
    if (rnd>=min)
      data[i]=rnd/2;
    else
      data[i]=0;
  }
}

unsigned gustaSimetricnaMatrica::size() const {
  return (sz*sizeof(T)+sizeof(gustaSimetricnaMatrica));
}

void gustaSimetricnaMatrica::nule() {
  for (int i(sz-1);i>=0;i--)
    data[i]=0;
}

gustaSimetricnaMatrica & gustaSimetricnaMatrica::operator += ( const gustaSimetricnaMatrica & B ) {
  if (sirina()==B.sirina() && visina()==B.visina()) 
    for (int i(sz-1);i>=0;i--)
      data[i]+=B.data[i];
  else
    throw DIMENZIJE_SE_NE_PODUDARAJU;
  return *this;
}

gustaSimetricnaMatrica & gustaSimetricnaMatrica::operator -= ( const gustaSimetricnaMatrica & B ) {
  if (sirina()==B.sirina() && visina()==B.visina()) 
    for (int i(sz-1);i>=0;i--)
      data[i]-=B.data[i];
  else
    throw DIMENZIJE_SE_NE_PODUDARAJU;
  return *this;
}

gustaSimetricnaMatrica & gustaSimetricnaMatrica::operator *= ( T faktor ) {
  for (int i(sz-1);i>=0;i--)
    data[i]*=faktor;
}

gustaSimetricnaMatrica & gustaSimetricnaMatrica ::operator /= ( T faktor ) {
  if (faktor==0) 
    throw DELJENJE_NULOM;
  for (int i(sz-1);i>=0;i--)
    data[i]/=faktor;
}

bool gustaSimetricnaMatrica::operator == ( const gustaSimetricnaMatrica & B ) const {
  bool ret = true;
  if (sirina()!=B.sirina() || visina()!=B.visina())
    ret = false;
  else
    for (int i(sz-1);i>=0;i--) {
      if (data[i]!=B.data[i]) {
        ret = false;
        break;
      }
    }
  return ret;
}

bool gustaSimetricnaMatrica::operator != ( const gustaSimetricnaMatrica & B ) const {
  return !operator==(B);
}

} // namespace


