/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#include <iostream>
#include <vector>

#include "common.h"

#include "matrica.hh"
#include "gustaMatrica.hh"
#include "gustaKvadratnaMatrica.hh"
#include "gustaSimetricnaMatrica.hh"
#include "retkaMatrica.hh"
#include "funkcije.hh"
#include "latexExport.hh"

using namespace std;

namespace jwork {

ostream & SLJ_LATEX_JEDNACINE(ostream & ostr, const matrica & A, const matrica & b, const matrica & x, unsigned sys) {
  ostr << "$$" << endl << "\\begin{array}{";
    ostr << 'r';
  ostr << "l}" << endl;

  for (unsigned j=0;j<A.visina();j++) {
    bool ispisanPrvi(false);
    for (unsigned i=0;i<A.sirina();i++) {
      int znak ( A.get(i,j)>=0 ? 1:-1 );
      if (znak==1 && ispisanPrvi && A.get(i,j)!=0)
        cout << '+';
      if (znak==-1 && A.get(i,j)!=0)
        cout << '-';
      if (A.get(i,j)!=0) {
        if (fabs(A.get(i,j))!=1) 
          ostr << fabs(A.get(i,j)); 
        ostr << "x_{" << (i+1) << "}";
        ispisanPrvi=true;
      }
    }

    cout << "&=" << b.get(0,j);
    
    if (j!=A.visina()-1)
      ostr << "\t\\\\";
    ostr << endl;
  }
  
  ostr << "\\end{array}" << endl << "$$" << endl;
  
}

ostream & SLJ_LATEX_MATRICNO(ostream & ostr, const matrica & A, const matrica & b, const matrica & x, unsigned sys) {
  ostr << "$$" << endl << "\\begin{array}{ccc}" << endl;
  ostr << "\\left[ \\begin{array}{";
  for (unsigned i(0);i<A.sirina();i++)
    ostr << 'r';
  ostr << '}' << endl;

  for (unsigned j=0;j<A.visina();j++) {
    for (unsigned i=0;i<A.sirina();i++) {
      ostr << ' ' << A.get(i,j) ;
      if (i!=A.sirina()-1)
        ostr << " &";
    }
    if (j!=A.visina()-1)
      ostr << "\t\\\\";
    ostr << endl;
  }
  
  ostr << "\\end{array} \\right]" << endl << '&' << endl;
  ostr << "\\left[ \\begin{array}{l}" << endl;
  for (unsigned j=0;j<b.visina();j++) {
    ostr << '\t' << "x_{" << (j+1) << "}";
    if (j!=b.visina()-1)
      ostr << "\t\\\\";
    ostr << endl;
  }
  ostr << "\\end{array} \\right] =" << endl << '&' << endl;
  ostr << "\\left[ \\begin{array} {r} "<< endl;
  for (unsigned j=0;j<b.visina();j++) {
    ostr << '\t' << b.get(0,j) ;
    if (j!=b.visina()-1)
      ostr << "\t\\\\";
    ostr << endl;
  }
  ostr << "\\end{array} \\right]" << endl;
  ostr << "\\end{array}" << endl << "$$" << endl;
  return ostr;
}

ostream & latexHeader(ostream & ostr) {
  ostr << "\\documentclass[a4paper]{article}" << endl;
  ostr << "\\usepackage{amsfonts}" << endl;
  ostr << "\\author{Igor Jeremi\' c}" << endl;
  ostr << "\\addtolength{\\hoffset}{-1cm}" << endl;
  ostr << "\\addtolength{\\textwidth}{1cm}" << endl;
  ostr << "\\addtolength{\\voffset}{-1cm}" << endl;
  ostr << "\\addtolength{\\textheight}{1cm}" << endl;
  ostr << "\\begin{document}" << endl;
  return ostr;  
}

ostream & latexFooter(ostream & ostr) {
  ostr << "\\end{document}" << endl;
  return ostr;
}

} // namespace jwork

