#include <iostream>
#include <mpi.h>

using namespace std;

void master(int brojProcesa) {
  double poruka;
  for (unsigned i=1; i<brojProcesa; i++) {
    poruka = 1.0/i;
    MPI::COMM_WORLD.Send( &poruka, 1, MPI::DOUBLE, i, 0);
  }
}

void slave(int procesID) {
  double poruka;
  MPI::COMM_WORLD.Recv( &poruka, 1, MPI::DOUBLE, 0, 0);
  cout << "Process " << procesID << " je primio " << poruka << " od master procesa " << endl;
}

int main(int argc, char **argv) {

  MPI::Init(argc, argv);
  int mojID       = MPI::COMM_WORLD.Get_rank();
  int brojProcesa = MPI::COMM_WORLD.Get_size();
  
  if (mojID==0)
    master(brojProcesa);
  else
    slave(mojID);
  
  MPI::Finalize();
}
