/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#if !defined retkaMatrica_hh
#define retkaMatrica_hh

#include <iostream>
#include <utility>
#include <map>

#include "matrica.hh"

using namespace std;

namespace jwork {

typedef pair<unsigned,unsigned>       pos;
typedef map<pos,T>::iterator          positer;
typedef map<pos,T>::const_iterator    cpositer;

class retkaMatrica : public matrica {
  private:
    map <pos,T> data;

    bool postoji( pos & p, cpositer & iter ) const;
    void obrisi( pos & p );

  public:
    retkaMatrica( unsigned s=1, unsigned v=1);
    retkaMatrica(const retkaMatrica &A);
    retkaMatrica & operator=(const retkaMatrica &A);
    ~retkaMatrica();

    void sviElementi() const;

    T get(unsigned x, unsigned y) const;
    void set(unsigned x, unsigned y, T broj);
    unsigned size() const;
    void nule();
    void postaviNovuMatricu(unsigned sirina, unsigned visina);


};

} // namespace

#endif
