/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/
 
#include <iostream>
#include <vector>

#include "matrica.hh"
#include "funkcije.hh"
#include "slj.hh"

using namespace std;

namespace jwork {

T maxElementInVector(const vector<T> &v) {
  if (v.size()==1) 
    return v[0];
  T max(0.0);
  for (int k(v.size()-1);k>=0;k--)
    if (v[k]>max)
      max=v[k];
  return max;   
}

/* 
 * ucitajSLJ(istream&, matrica&, matrica &) 
 * ucitava sistem linearnih jednacina zapisan u strogo zadatoj formi
 * u prvom redu ocekuje dimenziju sistema i to u obliku "(n x n | m)"
 * gde je n - dimenzija matrice, m broj slobodnih vektora, zatim se
 * ocekuje unosenje produzene matrice (razdvojene znakom '|') kao sto
 * je napisano u komentarima.
 * 
 * Svako nepridrzavanje ovih pravila povlaci za sobom izuzetak
 *
 * ulaz je saglasan sa metodom matrica.ispisi(matrica)
 * odnosno ispisiSLJ(ostr &,matrica &,matrica &)
 * 
 * (3 x 3 | 2)
 * [ 8.001 -1.00 3.000 | 6.000 -2.00 
 *   3.000 11.00 -3.00 | 13.00 -13.0 
 *   -1.00 3.000 6.001 | 2.000 46.00 ]
 */
 
bool ucitajDimenzijuSistema(unsigned *_n, unsigned *_m,istream & istr) {
  unsigned n1,m,n;
  char c;
  istr >> c;  if (c!='(') return false;
  istr >> n;  if (n<=0)   return false;
  istr >> c;  if (c!='x') return false;
  istr >> n1; if (n1!=n)  return false;
  istr >> c;  if (c!='|') return false;
  istr >> m;  if (m<=0)   return false;
  istr >> c;  if (c!=')') return false;
  *_n=n;
  *_m=m;
  istr >> c;  if (c!='[') return false;
  return true;      
}
 
istream & ucitajSLJ(istream & istr, matrica & A, matrica & b) {
  char c;
  unsigned n,m;
  T x;

  if (!ucitajDimenzijuSistema(&n,&m,istr))
    throw NEISPRAVAN_ULAZ;

  A.postaviNovuMatricu(n,n);
  b.postaviNovuMatricu(m,n);


  for (unsigned j=0;j<n;j++) {
    for (unsigned i=0;i<n;i++) {
      istr >> x;
      A.set(i,j,x);
    }
    istr >> c;
    if (c!='|') throw NEISPRAVAN_ULAZ;
    for (unsigned i=0;i<b.sirina();i++) {
      istr >> x;
      b.set(i,j,x);
    }
  }

  istr >> c;
  if (c!=']') throw NEISPRAVAN_ULAZ;

  return istr;
}

ostream & ispisiSLJ(ostream & ostr, matrica & A, matrica & b) {
  return A.ispisi(ostr,&b);
}

} // namespace

