/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#if !defined slj_hh
#define slj_hh
 
namespace jwork {

T maxElementInVector(const vector<T> &v);
istream & ucitajSLJ(istream & istr, matrica & A, matrica & b);
ostream & ispisiSLJ(ostream & ostr, matrica & A, matrica & b);

bool ucitajDimenzijuSistema(unsigned *_n, unsigned *_m,istream & istr);


/*
 * sablon f-je moraju biti implementirane na ovom mestu,
 * jer se ne mogu smestiti u objektni fajl kada nisu vezane za konkretan tip
**/

template <class TM>
unsigned SLJ_JacobiIter(const TM & A, TM b, matrica & x, bool gaussSaidel=false, bool echomode=false) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;
    
  if (x.visina()!=b.visina() || x.sirina()!=b.sirina())
    throw DIMENZIJE_NISU_SAGLASNE;
    
  TM AA(A);
  AA.pripremiZaJacobi(b);
//  cout << "posle pripreme za jacobi (seq):" << endl;
//ispisiStanjeBrojaca(cout);

  T q(AA.normaRedova());

  if (q>=1)
    throw NORMA_NEODGOVARA;
  
  T qq=q/(1-q);
  
  if (echomode) 
    cout << "NORMA JE: " << q << " qq=" << qq <<  endl;

  x.nule();
  
  vector <T> maxRazlike(b.sirina());

  unsigned i;
  for (i=0;i<MAXITER;i++) {
    AA.jacobiIteracija(b,x,maxRazlike,gaussSaidel);
    if (echomode) {
      cout << i << '\t';
      ispisi_vektore_za_matlab(x,10);
/*
      cout << redukuj_sirinu(maxElementInVector(maxRazlike),10);
      if (maxRazlike.size()>1) {
        cout << " < ";
        for (unsigned qw=0;qw<maxRazlike.size();qw++)
          cout <<  redukuj_sirinu(maxRazlike[qw],10);
        cout << " >";
      }
      cout << endl;
*/
    }
   
    if (qq*maxElementInVector(maxRazlike) < EPSILON)
      break;
  }

  return i+1;    
}

template <class TM>
bool SLJ_Gauss(const TM & A, TM b, matrica & x) {
  if (!A.kvadratna())
    throw MATRICA_MORA_BITI_KVADRATNA;
    
  if (x.visina()!=b.visina() || x.sirina()!=b.sirina())
    throw DIMENZIJE_NISU_SAGLASNE;
    
  TM AA(A);
  return AA.gaussResiSistem(&b,&x);
}


} // namespace

#endif

