/*
 * projekat: Seminarski rad iz numerickih metoda
 * naziv   : Iterativni metod za resavanje sistema linearnih jednacina
 * student : Igor Jeremic ( 99/115 ) - igor@jWork.net
 * profesor: Desanka Radunovic
 * asistent: Filip Maric
 * datum   : novembar 2003.
**/

#if !defined timetest_hh
#define timetest_hh

namespace jwork {

#if defined GNUCPP_UNIX

#include <sys/time.h>

unsigned long tt_sec, utt_sec;
struct timeval at;
struct timezone bt;

void startTTest(bool pisi = false) {
	if (pisi)
		cout << "start test" << endl;
	gettimeofday(&at,&bt); tt_sec=at.tv_sec; utt_sec=at.tv_usec;
}

double finishTTest(bool pisi=false) {
	gettimeofday(&at,&bt);	// cout << at.tv_sec << " " << at.tv_usec << endl;
	double eltime = ((at.tv_sec-tt_sec)*1000000 + at.tv_usec-utt_sec)/1000000.0;

	if (pisi) {
		cout << "vreme izvrsavanja testa :"<<eltime<<"sec"<<endl;
//		cout << "end test" << endl;
	}
	return eltime;
}

#endif

#if defined BORLANDCPP_DOS

#include   <dos.h>

struct  time dost;

void startTTest(bool pisi = false) {
	if (pisi)
		cout << "start test" << endl;
	gettime(&dost);
}

double finishTTest(bool pisi=false) {
   struct time dost1;
   gettime(&dost1);

   double eltime = (double)(dost1.ti_hour-dost.ti_hour)*(60*60) +
   					 (double)(dost1.ti_min-dost.ti_min)*(60) +
                   (double)(dost1.ti_sec-dost.ti_sec) +
                   (double)(dost1.ti_hund-dost.ti_hund)*(1/100.0);

	if (pisi) {
		cout << "vreme izvrsavanja testa :"<<eltime<<"sec"<<endl;
//		cout << "end test" << endl;

	}
	return eltime;
}

#endif

} // namespace jwork

#endif // if !defined timetest_hh

