theory Equality
imports Main
begin

thm refl
thm sym
thm trans
thm cong

lemma "\<forall>x y z. x = y \<and> z = y \<longrightarrow> f x = f z" 
  apply (rule allI, rule allI, rule allI)
  apply (rule impI)
  apply (erule conjE)
  apply (rule_tac ?f = "f" and ?g = "f" in cong)
  apply (rule refl)
  apply (rule_tac ?s="y" in trans)
  apply (assumption)
  apply (rule sym)
  apply (assumption)
done

(* simulacija Birkhofovog sistema pravila u Isabelle-u *)
lemma "\<forall>x y z. f (f x y) z = f x (f y z) \<Longrightarrow> 
       \<forall>x. f e x = x \<Longrightarrow> 
       \<forall>x. f x e = x \<Longrightarrow> 
       f a b = e \<Longrightarrow> 
       f b a = e \<Longrightarrow> 
       f a c = e \<Longrightarrow> 
       f c a = e \<Longrightarrow>   b = c" 
  apply (rule_tac ?s="f c e" in trans)
  apply (rule_tac ?s="f c (f a b)" in trans)
  apply (rule_tac ?s="f (f c a) b" in trans)
  apply (rule_tac ?s="f e b" in trans)
  apply (rule sym)
  apply (erule_tac ?P="\<lambda>x. f e x = x" and ?x="b" in allE)
  apply (assumption)
  apply (rule_tac ?f="f e" and ?g="f (f c a)" and ?x="b" and ?y="b" in cong)
  apply (rule_tac ?f="f" and ?g="f" and ?x="e" and ?y="f c a" in cong)
  apply (rule refl)
  apply (rule sym)
  apply (assumption)
  apply (rule refl)
  apply (erule_tac ?x="c" in allE)
  apply (rule_tac ?x="a" and ?P="\<lambda>y. \<forall>z. f (f c y) z = f c (f y z)" in allE)
  apply (assumption)
  apply (rule_tac ?x="b" and ?P="\<lambda>z. f (f c a) z = f c (f a z)" in allE)
  apply (assumption)
  apply (assumption)
  apply (rule_tac ?f="f c" and ?g="f c" and ?x="f a b" and ?y="e" in cong)
  apply (rule refl)
  apply (assumption)
  apply (rule_tac ?x="c" and ?P="\<lambda>x. f x e = x" in  allE)
  apply (assumption)
  apply (assumption)
done
end
