`include "datapath.v"
`include "cu.v"

/* Model procesora opste namene. Na ulazu ima signal casovnika clk
   koji kontrolise ritam njegovog rada. Magistrala podataka data je
   dvosmerna, dok je adresna magistrala addr izlazna magistrala preko
   koje se salje adresa. Signali bus_* sluze za komunikaciju preko
   magistrale, dok je halt_signal namenjen iskljucivanju racunara */
module cpu(clk, data, addr, bus_request, bus_grant, bus_in_use, bus_command, bus_wait, halt_computer);
   input clk;
   inout [31:0] data;
   output [31:0] addr;
   output 	 bus_request;
   output 	 bus_command;
   output 	 bus_in_use;	 
   input 	 bus_grant;
   input 	 bus_wait;	 
   output 	 halt_computer;	 


   /* Zice za povezivanje sa datapath komponentom i memorijom */
   wire [3:0] 	 reg_a_sel;
   wire [3:0] 	 reg_b_sel;

   wire 	 e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
		 e_alu, 
		 e_ac_alu_in, e_ac_a_out, e_ac_b_out,
		 e_psw_in,
		 e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
		 e_ir_a_in, e_ir_b_in,
		 e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
		 e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const;
 
   
   wire [3:0] 	 psw_out;
   wire [3:0] 	 alu_op;
   wire [7:0] 	 ir_op_code;
   wire [3:0] 	 ir_dst_reg;
   wire [3:0] 	 ir_src_reg;

   /* Datapath komponenta */
   datapath _datapath(clk, psw_out, 
		      ir_op_code, ir_dst_reg, ir_src_reg,
		      e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
		      e_alu, 
		      e_ac_alu_in, e_ac_a_out, e_ac_b_out,
		      e_psw_in,
		      e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
		      e_ir_a_in, e_ir_b_in,
		      e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
		      e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const,  
		      alu_op, reg_a_sel, reg_b_sel,
		      data, addr);
   
   
   /* Kontrolna jedinica */
   cu _cu(clk, psw_out, ir_op_code, ir_dst_reg, ir_src_reg,
	  e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
	  e_alu, 
	  e_ac_alu_in, e_ac_a_out, e_ac_b_out,
	  e_psw_in,
	  e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
	  e_ir_a_in, e_ir_b_in,
	  e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
	  e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const,	  
	  alu_op, reg_a_sel, reg_b_sel, bus_request, bus_grant, bus_in_use, bus_command, bus_wait, halt_computer);   	     
   
endmodule // cpu
