/* IR registar cuva operacioni kod instrukcije, kao i kodove registara
   koji su operandi, u slucaju instrukcija koje imaju dva registra za
   operande. Moguce je ucitati vrednost sa bilo koje od magistrala.
   Vrednost sacuvana u IR registru je dostupna preko izlaza op_code,
   dst_reg i src_reg (svaki izlaz daje odgovarajucu komponentu). Ova
   vrednost se povezuje na kontrolnu jedinicu. */
module ir(clk, bus_a, bus_b, op_code, dst_reg, src_reg, e_a_in, e_b_in);
   input clk;
   input[31:0] bus_a, bus_b;
   input       e_a_in, e_b_in;
   output [7:0] op_code;   
   output [3:0]  dst_reg;
   output [3:0]  src_reg;
         
   reg [15:0]  r;

   assign op_code = r[7:0];
   assign dst_reg = r[11:8];
   assign src_reg = r[15:12];

   initial
     r <= 0;
   
   always @(negedge clk)
     if(e_a_in)
       r <= bus_a[15:0];

   always @(negedge clk)
     if(e_b_in)
       r <= bus_b[15:0];   

   always @(r)
     $display($time, ": ir = %h|%h|%h", r[15:12], r[11:8], r[7:0]);	  

   
   
   
endmodule // ir
