`include "flags.v"
`include "cond_codes.v"


/* Ovo pomocno kombinatorno kolo zapravo se instancira unutar 
 kontrolne jedinice, gde mu je uloga da na osnovu izabranog
 koda uslova i trenutne vrednosti PSW registra odredjuje da li
 je trazeni uslov ispunjen ili ne. */
module psw_checker(cond_code, psw, out);
   input [3:0] cond_code; // 4-bitni kod uslova koji se ispituje
   input [3:0] psw; // stanje flegova
   output reg    out; // 1 ukoliko je uslov ispunjen, 0 u suprotnom

   always @(cond_code or psw)
     case(cond_code)
       `COND_JMP:
	 out <= `TRUE;
       `COND_JE:
	 out <= psw[`ZF];
       `COND_JNE:
	 out <= ~psw[`ZF];
       `COND_JA:
	 out <= ~(psw[`ZF] | psw[`CF]);
       `COND_JB:
	 out <= psw[`CF];
       `COND_JAE:
	 out <= ~psw[`CF];
       `COND_JBE:
	 out <= psw[`ZF] | psw[`CF];
       `COND_JG:
	 out <= ~(psw[`ZF] | (psw[`OF] ^ psw[`SF]));
       `COND_JL:
	 out <= psw[`OF] ^ psw[`SF];
       `COND_JGE:
	 out <= ~(psw[`OF] ^ psw[`SF]);
       `COND_JLE:
	 out <= psw[`ZF] | (psw[`OF] ^ psw[`SF]);
       default:
	 out <= `FALSE;       
     endcase
endmodule // psw_checker

